IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_Cta_Cont_Saldo]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION [dbo].[CF_Cta_Cont_Saldo] 
END
GO

CREATE FUNCTION [dbo].[CF_Cta_Cont_Saldo] (@Desde DATETIME
											,@Hasta DATETIME
											,@Alias INT
											,@Id_Plan_Cta INT
											,@Flag_Inc_SA TINYINT
											,@Flag_CentroCosto TINYINT
											,@Id_Centro_Costo CHAR(10)
											,@Flag_CentroCosto_Recur TINYINT
											,@Flag_Unid_Neg TINYINT
											,@Id_Unid_Negocio CHAR(10)
											,@Flag_SoloAsientos TINYINT 
										)
RETURNS DECIMAL(16,2)
AS
BEGIN

IF @Alias = 0	
	RETURN 0;


DECLARE @Importe DECIMAL(16,2)
		,@Id_Cta_Contable INT
		,@Id_Centro_Costo_Min CHAR(10)
		,@Id_Centro_Costo_Max CHAR(10)
		,@Id_Unid_Negocio_Min CHAR(10)
		,@Id_Unid_Negocio_Max CHAR(10)
		,@AliasRecur INT
		,@Imputable INT
		

SELECT TOP 1 @Id_Cta_Contable = Id_Cta_Contable , @Imputable = Imputable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta AND Alias = @Alias

IF @Flag_CentroCosto <> 0
BEGIN
	SET @Id_Centro_Costo_Min = ISNULL(@Id_Centro_Costo,'')
	SET @Id_Centro_Costo_Max = ISNULL(@Id_Centro_Costo,'')
END
ELSE
BEGIN
	SET @Id_Centro_Costo_Min = ISNULL((SELECT MIN(Id_Centro_Costo) FROM Centro_Costos),'')
	SET @Id_Centro_Costo_Max = ISNULL((SELECT MAX(Id_Centro_Costo) FROM Centro_Costos),'')
END

IF @Flag_Unid_Neg <> 0
BEGIN
	SET @Id_Unid_Negocio_Min = ISNULL(@Id_Unid_Negocio,'')
	SET @Id_Unid_Negocio_Max = ISNULL(@Id_Unid_Negocio,'')
END
ELSE
BEGIN
	SET @Id_Unid_Negocio_Min = ISNULL((SELECT MIN(Id_Unid_Negocio) FROM Empresas_Unid_Negocios),'')
	SET @Id_Unid_Negocio_Max = ISNULL((SELECT MAX(Id_Unid_Negocio) FROM Empresas_Unid_Negocios),'')
END

IF @Flag_Inc_SA <> 0
	SET @Desde = '19000101'
	
	
SET @Importe = 0	

SET @Importe = @Importe + ISNULL((SELECT ISNULL(SUM(ISNULL(I.Debe,0)) - SUM(ISNULL(I.Haber,0)), 0)
					FROM Asientos_Items I, Asientos A 
					WHERE A.Id_Asiento = I.Id_Asiento
                    AND I.Id_Cta_Contable = @Id_Cta_Contable 
                    AND A.Balanceado = 1
                    AND A.Fecha >= @Desde
                	AND A.Fecha < @Hasta
					AND ISNULL(I.Id_Centro_Costo,'') BETWEEN @Id_Centro_Costo_Min AND @Id_Centro_Costo_Max 
				    AND ISNULL(A.Id_Unid_Negocio,'') BETWEEN @Id_Unid_Negocio_Min AND @Id_Unid_Negocio_Max),0)
					 

IF ISNULL(@Flag_SoloAsientos,0) = 0
	SET @Importe = @Importe + ISNULL((SELECT ISNULL(SUM(ISNULL(O.Debe,0)) - SUM(ISNULL(O.Haber,0)), 0)
					FROM Cbtes_Ctas_Contables O, Cbtes C, Cbtes_Tipos T
					WHERE C.Id_Trans = O.Id_Trans 
                    AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte 
                    AND T.Compromete_Asientos IN (1,-1) 
                    AND O.Id_Cta_Contable = @Id_Cta_Contable
                    AND ISNULL(O.Id_Asiento,0) = 0 
                    AND C.Id_Estado_Cbte NOT IN (0,3)
                    AND C.Periodo >= @Desde
                    AND C.Periodo < @Hasta + 1
					AND ISNULL(O.Id_Centro_Costo,'') BETWEEN @Id_Centro_Costo_Min AND @Id_Centro_Costo_Max 
				    AND ISNULL(T.Id_Unid_Negocio,'') BETWEEN @Id_Unid_Negocio_Min AND @Id_Unid_Negocio_Max),0)


/*recursividad ctas*/

DECLARE Cur_CF_Cta_Cont_Saldo CURSOR FOR SELECT Alias FROM Pla_Ctas_Cuentas_Contables WHERE Id_Cuenta_Padre = @Alias AND Id_Plan_Cta = @Id_Plan_Cta
OPEN Cur_CF_Cta_Cont_Saldo
FETCH NEXT FROM Cur_CF_Cta_Cont_Saldo INTO @AliasRecur
WHILE @@FETCH_STATUS=0
BEGIN
	SET @Importe = @Importe + dbo.CF_Cta_Cont_Saldo (@Desde	
											,@Hasta 
											,@AliasRecur 
											,@Id_Plan_Cta
											,@Flag_Inc_SA 
											,@Flag_CentroCosto 
											,@Id_Centro_Costo 
											,@Flag_CentroCosto_Recur 
											,@Flag_Unid_Neg 
											,@Id_Unid_Negocio 
											,@Flag_SoloAsientos
											)
	FETCH NEXT FROM Cur_CF_Cta_Cont_Saldo INTO @AliasRecur
END
CLOSE Cur_CF_Cta_Cont_Saldo
DEALLOCATE Cur_CF_Cta_Cont_Saldo	
/* frin recursividad ctas*/


/*recursividad centro de costo*/
IF ISNULL(@Flag_CentroCosto_Recur,0) <> 0 AND ISNULL(@Imputable,0) <> 0
BEGIN
	DECLARE Cur_CF_Cta_Cont_Saldo_CC CURSOR FOR SELECT Id_Centro_Costo FROM Centro_Costos WHERE Id_Centro_Costo_Padre = @Id_Centro_Costo
	OPEN Cur_CF_Cta_Cont_Saldo_CC
	FETCH NEXT FROM Cur_CF_Cta_Cont_Saldo_CC INTO @Id_Centro_Costo
	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @Importe = @Importe + dbo.CF_Cta_Cont_Saldo (@Desde	
											,@Hasta 
											,@Alias 
											,@Id_Plan_Cta
											,@Flag_Inc_SA 
											,@Flag_CentroCosto 
											,@Id_Centro_Costo 
											,@Flag_CentroCosto_Recur 
											,@Flag_Unid_Neg 
											,@Id_Unid_Negocio 
											,@Flag_SoloAsientos
											)
		FETCH NEXT FROM Cur_CF_Cta_Cont_Saldo_CC INTO @Id_Centro_Costo
	END
	CLOSE Cur_CF_Cta_Cont_Saldo_CC
	DEALLOCATE Cur_CF_Cta_Cont_Saldo_CC
END
/*find e recurisivida centro de costo*/
RETURN @Importe
END 
